﻿#pragma once

#include  "CommandProcessorState.hpp"

SZ_NS_BEG(szpp)

struct ArchiveUpdaterOptions;

SZ_NS_END(szpp)

class ProcessUI;

class CommandProcessor
{
public:

  CommandProcessor(const szstring &cmdline, ProcessUI *pUI);
  ~CommandProcessor();

  const CommandProcessorState &GetState() const { return state; }

private:

  static unsigned int WINAPI ThreadProc(void *lpParameter);

  bool Quitting() const;

  szstring Normalize(const szstring &path);

  void Decompress(const szstring &archivePath);
  void Compress(const szstring &archivePath, const std::vector<szstring> &files, szpp::ArchiveUpdaterOptions *options);

  const szstring        &cmdline;
  ProcessUI             *pUI;
  HANDLE                hThread;
  CommandProcessorState state;
};
